#ifndef __TL__MB_INFO_H
#define	__TL__MB_INFO_H

#ifdef __cplusplus
extern "C"
{
#endif

#include <stdint.h>

/* bits in mboot_info_t->flags */
#define MBINFO_MEM		0x00000001
#define MBINFO_BOOT_DEV		0x00000002
#define MBINFO_CMD_LINE		0x00000004
#define MBINFO_MODS		0x00000008
//#define MBINFO_AOUT_SYMS	0x00000010
//#define MBINFO_ELF_SHDR	0x00000020
#define MBINFO_MEM_MAP		0x00000040
#define MBINFO_DRIVE_INFO	0x00000080
#define MBINFO_CONFIG_TABLE	0x00000100
#define MBINFO_LOADER_NAME	0x00000200
#define MBINFO_APM_TABLE	0x00000400
#define MBINFO_VIDEO_INFO	0x00000800

typedef struct
{
	uint32_t flags		__PACKED__;
	uint32_t conv_mem	__PACKED__;	/* MBINFO_MEM */
	uint32_t ext_mem	__PACKED__;	/* MBINFO_MEM */
	uint32_t boot_dev	__PACKED__;	/* MBINFO_BOOT_DEV */
	uint32_t cmd_line	__PACKED__;	/* MBINFO_CMD_LINE */
/* modules */
	uint16_t num_mods	__PACKED__;	/* MBINFO_MODS */
	uint16_t unused2	__PACKED__;
	uint32_t mods_adr	__PACKED__;	/* MBINFO_MODS */
/* no symbol table (MBINFO_AOUT_SYMS) or section table (MBINFO_ELF_SHDR) */
	uint32_t unused3[4]	__PACKED__;
/* BIOS memory map */
	uint32_t map_len	__PACKED__;	/* MBINFO_MEM_MAP */
	uint32_t map_adr	__PACKED__;	/* MBINFO_MEM_MAP */
/* info about hard drives */
	uint32_t drives_len	__PACKED__;	/* MBINFO_DRIVE_INFO */
	uint32_t drives_adr	__PACKED__;	/* MBINFO_DRIVE_INFO */
/* ROM config table */
	uint32_t config_table	__PACKED__;	/* MBINFO_CONFIG_TABLE */
/* boot loader name */
	uint32_t loader_name	__PACKED__;	/* MBINFO_LOADER_NAME */
/* APM table */
	uint32_t apm_table	__PACKED__;	/* MBINFO_APM_TABLE */
/* video info */
	uint32_t vbe_ctrl_info	__PACKED__;	/* MBINFO_VIDEO_INFO */
	uint32_t vbe_mode_info	__PACKED__;	/* MBINFO_VIDEO_INFO */
	uint16_t vbe_mode	__PACKED__;	/* MBINFO_VIDEO_INFO */
	uint16_t vbe_iface_seg	__PACKED__;	/* MBINFO_VIDEO_INFO */
	uint16_t vbe_iface_off	__PACKED__;	/* MBINFO_VIDEO_INFO */
	uint16_t vbe_iface_len	__PACKED__;	/* MBINFO_VIDEO_INFO */
} mboot_info_t;

/* Multiboot modules */
typedef struct
{
	uint32_t start_adr	__PACKED__;
	uint32_t end_adr	__PACKED__;
	uint32_t cmd_line	__PACKED__;
	uint32_t unused		__PACKED__;
} mboot_mod_t;

/* Multiboot BIOS memory ranges */
typedef struct
{
	uint32_t len		__PACKED__; /* =24=size of this struct */
//	uint64_t adr		__PACKED__;
	uint32_t adr, res_adr	__PACKED__;
//	uint64_t size		__PACKED__;
	uint32_t size, res_size	__PACKED__;
	uint32_t type		__PACKED__;
} mboot_range_t;

typedef struct
{
	uint32_t len		__PACKED__;
	uint8_t drive_num	__PACKED__; /* INT 13h drive number */
	uint8_t use_lba		__PACKED__;
/* drive geometry values (use_lba==0) */
	uint16_t cyls		__PACKED__;
	uint8_t heads		__PACKED__;
	uint8_t sects		__PACKED__;
/* ...I/O port fields can go here; adjust len accordingly... */
} mboot_drive_t;

#ifdef __cplusplus
}
#endif

#endif
